<?php
/*
 #########################################################################
 #                       xt:Commerce Shopsoftware
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # Copyright 2021 xt:Commerce GmbH All Rights Reserved.
 # This file may not be redistributed in whole or significant part.
 # Content of this file is Protected By International Copyright Laws.
 #
 # ~~~~~~ xt:Commerce Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
 #
 # https://www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # @copyright xt:Commerce GmbH, www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # xt:Commerce GmbH, Maximilianstrasse 9, 6020 Innsbruck
 #
 # office@xt-commerce.com
 #
 #########################################################################
 */


defined('_VALID_CALL') or die('Direct Access is not allowed.');

require_once _SRV_WEBROOT . _SRV_WEB_PLUGINS. 'xt_paypal_checkout/classes/constants.php';
require_once _SRV_WEBROOT . _SRV_WEB_PLUGINS. 'xt_paypal_checkout/installer/functions.php';

require_once _SRV_WEBROOT . _SRV_WEB_PLUGINS. 'xt_paypal_checkout/classes/class.paypal_checkout.php';

global $db, $store_handler, $language;

$payment_id = $db->GetOne("SELECT payment_id FROM ".TABLE_PAYMENT. " WHERE payment_code = 'xt_paypal_checkout_pui'");
if($payment_id)
{
    foreach ($store_handler->getStores() as $store) {
        $sid = $store['id'];

        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_CONFIGURATION_PAYMENT . " WHERE config_key = 'XT_PAYPAL_CHECKOUT_PUI_SEND_INVOICE_TRIGGER_STATUS' and shop_id = ?", [$sid]);

        if (!$exits) {
            $db->Execute("INSERT INTO " . TABLE_CONFIGURATION_PAYMENT . " 
                   ( `config_key`,                                        `config_value`, `group_id`, `sort_order`, `type`,     `url`,               `payment_id`, `shop_id`) 
            VALUES ( 'XT_PAYPAL_CHECKOUT_PUI_SEND_INVOICE_TRIGGER_STATUS', '23',           '0',        '50',         'dropdown', 'status:order_status', ?,            ?);",
                [$payment_id, $sid]);
        }
    }

    foreach($language->_getLanguageList('admin') as $lng)
    {
        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_LANGUAGE_CONTENT . " WHERE language_key = 'XT_PAYPAL_CHECKOUT_PUI_SEND_INVOICE_TRIGGER_STATUS_TITLE' and language_code = ?", [$lng['code']]);
        if(!$exits)
        {
            $s = "Generate invoice trigger status (xt_orders_invoices)";
            if($lng['code'] == 'de') $s = "Auslöser-Status Rechnungserzeugung (xt_orders_invoices)";

            $db->Execute("INSERT INTO ".TABLE_LANGUAGE_CONTENT." 
                   ( `translated`, `language_code`, `language_key`,                                             `language_value`, `class`, `plugin_key`, `readonly`) 
            VALUES ( '0',           ?,              'XT_PAYPAL_CHECKOUT_PUI_SEND_INVOICE_TRIGGER_STATUS_TITLE', ?              , 'admin', 'xt_paypal_checkout', '0');",
                [$lng['code'], $s]);
        }
    }

}

$payment_id = $db->GetOne("SELECT payment_id FROM ".TABLE_PAYMENT. " WHERE payment_code = 'xt_paypal_checkout_googlepay'");
if($payment_id)
{
    foreach ($store_handler->getStores() as $store) {
        $sid = $store['id'];

        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_CONFIGURATION_PAYMENT . " WHERE config_key = 'XT_PAYPAL_CHECKOUT_GOOGLEPAY_SEND_INVOICE_TRIGGER_STATUS' and shop_id = ?", [$sid]);

        if (!$exits) {
            $db->Execute("INSERT INTO " . TABLE_CONFIGURATION_PAYMENT . " 
                   ( `config_key`,                                        `config_value`, `group_id`, `sort_order`, `type`,     `url`,               `payment_id`, `shop_id`) 
            VALUES ( 'XT_PAYPAL_CHECKOUT_GOOGLEPAY_SEND_INVOICE_TRIGGER_STATUS', '23',           '0',        '50',         'dropdown', 'status:order_status', ?,            ?);",
                [$payment_id, $sid]);
        }
    }

    foreach($language->_getLanguageList('admin') as $lng)
    {
        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_LANGUAGE_CONTENT . " WHERE language_key = 'XT_PAYPAL_CHECKOUT_GOOGLEPAY_SEND_INVOICE_TRIGGER_STATUS_TITLE' and language_code = ?", [$lng['code']]);
        if(!$exits)
        {
            $s = "Generate invoice trigger status (xt_orders_invoices)";
            if($lng['code'] == 'de') $s = "Auslöser-Status Rechnungserzeugung (xt_orders_invoices)";

            $db->Execute("INSERT INTO ".TABLE_LANGUAGE_CONTENT." 
                   ( `translated`, `language_code`, `language_key`,                                             `language_value`, `class`, `plugin_key`, `readonly`) 
            VALUES ( '0',           ?,              'XT_PAYPAL_CHECKOUT_GOOGLEPAY_SEND_INVOICE_TRIGGER_STATUS_TITLE', ?              , 'admin', 'xt_paypal_checkout', '0');",
                [$lng['code'], $s]);
        }
    }

}

$payment_id = $db->GetOne("SELECT payment_id FROM ".TABLE_PAYMENT. " WHERE payment_code = 'xt_paypal_checkout_applepay'");
if($payment_id)
{
    foreach ($store_handler->getStores() as $store) {
        $sid = $store['id'];

        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_CONFIGURATION_PAYMENT . " WHERE config_key = 'XT_PAYPAL_CHECKOUT_APPLEPAY_SEND_INVOICE_TRIGGER_STATUS' and shop_id = ?", [$sid]);

        if (!$exits) {
            $db->Execute("INSERT INTO " . TABLE_CONFIGURATION_PAYMENT . " 
                   ( `config_key`,                                        `config_value`, `group_id`, `sort_order`, `type`,     `url`,               `payment_id`, `shop_id`) 
            VALUES ( 'XT_PAYPAL_CHECKOUT_APPLEPAY_SEND_INVOICE_TRIGGER_STATUS', '23',           '0',        '50',         'dropdown', 'status:order_status', ?,            ?);",
                [$payment_id, $sid]);
        }
    }

    foreach($language->_getLanguageList('admin') as $lng)
    {
        $exits = (int)$db->GetOne("SELECT 1 FROM " . TABLE_LANGUAGE_CONTENT . " WHERE language_key = 'XT_PAYPAL_CHECKOUT_APPLEPAY_SEND_INVOICE_TRIGGER_STATUS_TITLE' and language_code = ?", [$lng['code']]);
        if(!$exits)
        {
            $s = "Generate invoice trigger status (xt_orders_invoices)";
            if($lng['code'] == 'de') $s = "Auslöser-Status Rechnungserzeugung (xt_orders_invoices)";

            $db->Execute("INSERT INTO ".TABLE_LANGUAGE_CONTENT." 
                   ( `translated`, `language_code`, `language_key`,                                             `language_value`, `class`, `plugin_key`, `readonly`) 
            VALUES ( '0',           ?,              'XT_PAYPAL_CHECKOUT_APPLEPAY_SEND_INVOICE_TRIGGER_STATUS_TITLE', ?              , 'admin', 'xt_paypal_checkout', '0');",
                [$lng['code'], $s]);
        }
    }

}

ppcClearLanguageCache();
