<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Item type identification codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdItemTypeIdentificationCodes
{
    /**
     * Product version number
     */
    const UNTDID_7143_AA = 'AA';

    /**
     * Assembly
     */
    const UNTDID_7143_AB = 'AB';

    /**
     * HIBC (Health Industry Bar Code)
     */
    const UNTDID_7143_AC = 'AC';

    /**
     * Cold roll number
     */
    const UNTDID_7143_AD = 'AD';

    /**
     * Hot roll number
     */
    const UNTDID_7143_AE = 'AE';

    /**
     * Slab number
     */
    const UNTDID_7143_AF = 'AF';

    /**
     * Software revision number
     */
    const UNTDID_7143_AG = 'AG';

    /**
     * UPC (Universal Product Code) Consumer package code (1-5-5)
     */
    const UNTDID_7143_AH = 'AH';

    /**
     * UPC (Universal Product Code) Consumer package code (1-5-5-
     */
    const UNTDID_7143_AI = 'AI';

    /**
     * Sample number
     */
    const UNTDID_7143_AJ = 'AJ';

    /**
     * Pack number
     */
    const UNTDID_7143_AK = 'AK';

    /**
     * UPC (Universal Product Code) Shipping container code (1-2-
     */
    const UNTDID_7143_AL = 'AL';

    /**
     * UPC (Universal Product Code)/EAN (European article number)
     */
    const UNTDID_7143_AM = 'AM';

    /**
     * UPC (Universal Product Code) suffix
     */
    const UNTDID_7143_AN = 'AN';

    /**
     * State label code
     */
    const UNTDID_7143_AO = 'AO';

    /**
     * Heat number
     */
    const UNTDID_7143_AP = 'AP';

    /**
     * Coupon number
     */
    const UNTDID_7143_AQ = 'AQ';

    /**
     * Resource number
     */
    const UNTDID_7143_AR = 'AR';

    /**
     * Work task number
     */
    const UNTDID_7143_AS = 'AS';

    /**
     * Price look up number
     */
    const UNTDID_7143_AT = 'AT';

    /**
     * NSN (North Atlantic Treaty Organization Stock Number)
     */
    const UNTDID_7143_AU = 'AU';

    /**
     * Refined product code
     */
    const UNTDID_7143_AV = 'AV';

    /**
     * Exhibit
     */
    const UNTDID_7143_AW = 'AW';

    /**
     * End item
     */
    const UNTDID_7143_AX = 'AX';

    /**
     * Federal supply classification
     */
    const UNTDID_7143_AY = 'AY';

    /**
     * Engineering data list
     */
    const UNTDID_7143_AZ = 'AZ';

    /**
     * Milestone event number
     */
    const UNTDID_7143_BA = 'BA';

    /**
     * Lot number
     */
    const UNTDID_7143_BB = 'BB';

    /**
     * National drug code 4-4-2 format
     */
    const UNTDID_7143_BC = 'BC';

    /**
     * National drug code 5-3-2 format
     */
    const UNTDID_7143_BD = 'BD';

    /**
     * National drug code 5-4-1 format
     */
    const UNTDID_7143_BE = 'BE';

    /**
     * National drug code 5-4-2 format
     */
    const UNTDID_7143_BF = 'BF';

    /**
     * National drug code
     */
    const UNTDID_7143_BG = 'BG';

    /**
     * Part number
     */
    const UNTDID_7143_BH = 'BH';

    /**
     * Local Stock Number (LSN)
     */
    const UNTDID_7143_BI = 'BI';

    /**
     * Next higher assembly number
     */
    const UNTDID_7143_BJ = 'BJ';

    /**
     * Data category
     */
    const UNTDID_7143_BK = 'BK';

    /**
     * Control number
     */
    const UNTDID_7143_BL = 'BL';

    /**
     * Special material identification code
     */
    const UNTDID_7143_BM = 'BM';

    /**
     * Locally assigned control number
     */
    const UNTDID_7143_BN = 'BN';

    /**
     * Buyer's colour
     */
    const UNTDID_7143_BO = 'BO';

    /**
     * Buyer's part number
     */
    const UNTDID_7143_BP = 'BP';

    /**
     * Variable measure product code
     */
    const UNTDID_7143_BQ = 'BQ';

    /**
     * Financial phase
     */
    const UNTDID_7143_BR = 'BR';

    /**
     * Contract breakdown
     */
    const UNTDID_7143_BS = 'BS';

    /**
     * Technical phase
     */
    const UNTDID_7143_BT = 'BT';

    /**
     * Dye lot number
     */
    const UNTDID_7143_BU = 'BU';

    /**
     * Daily statement of activities
     */
    const UNTDID_7143_BV = 'BV';

    /**
     * Periodical statement of activities within a bilaterally
     */
    const UNTDID_7143_BW = 'BW';

    /**
     * Calendar week statement of activities
     */
    const UNTDID_7143_BX = 'BX';

    /**
     * Calendar month statement of activities
     */
    const UNTDID_7143_BY = 'BY';

    /**
     * Original equipment number
     */
    const UNTDID_7143_BZ = 'BZ';

    /**
     * Industry commodity code
     */
    const UNTDID_7143_CC = 'CC';

    /**
     * Commodity grouping
     */
    const UNTDID_7143_CG = 'CG';

    /**
     * Colour number
     */
    const UNTDID_7143_CL = 'CL';

    /**
     * Contract number
     */
    const UNTDID_7143_CR = 'CR';

    /**
     * Customs article number
     */
    const UNTDID_7143_CV = 'CV';

    /**
     * Drawing revision number
     */
    const UNTDID_7143_DR = 'DR';

    /**
     * Drawing
     */
    const UNTDID_7143_DW = 'DW';

    /**
     * Engineering change level
     */
    const UNTDID_7143_EC = 'EC';

    /**
     * Material code
     */
    const UNTDID_7143_EF = 'EF';

    /**
     * International Article Numbering Association (EAN)
     */
    const UNTDID_7143_EN = 'EN';

    /**
     * Fish species
     */
    const UNTDID_7143_FS = 'FS';

    /**
     * Buyer's internal product group code
     */
    const UNTDID_7143_GB = 'GB';

    /**
     * National product group code
     */
    const UNTDID_7143_GN = 'GN';

    /**
     * General specification number
     */
    const UNTDID_7143_GS = 'GS';

    /**
     * Harmonised system
     */
    const UNTDID_7143_HS = 'HS';

    /**
     * ISBN (International Standard Book Number)
     */
    const UNTDID_7143_IB = 'IB';

    /**
     * Buyer's item number
     */
    const UNTDID_7143_IN = 'IN';

    /**
     * ISSN (International Standard Serial Number)
     */
    const UNTDID_7143_IS = 'IS';

    /**
     * Buyer's style number
     */
    const UNTDID_7143_IT = 'IT';

    /**
     * Buyer's size code
     */
    const UNTDID_7143_IZ = 'IZ';

    /**
     * Machine number
     */
    const UNTDID_7143_MA = 'MA';

    /**
     * Manufacturer's (producer's) article number
     */
    const UNTDID_7143_MF = 'MF';

    /**
     * Model number
     */
    const UNTDID_7143_MN = 'MN';

    /**
     * Product/service identification number
     */
    const UNTDID_7143_MP = 'MP';

    /**
     * Batch number
     */
    const UNTDID_7143_NB = 'NB';

    /**
     * Customer order number
     */
    const UNTDID_7143_ON = 'ON';

    /**
     * Part number description
     */
    const UNTDID_7143_PD = 'PD';

    /**
     * Purchaser's order line number
     */
    const UNTDID_7143_PL = 'PL';

    /**
     * Purchase order number
     */
    const UNTDID_7143_PO = 'PO';

    /**
     * Promotional variant number
     */
    const UNTDID_7143_PV = 'PV';

    /**
     * Buyer's qualifier for size
     */
    const UNTDID_7143_QS = 'QS';

    /**
     * Returnable container number
     */
    const UNTDID_7143_RC = 'RC';

    /**
     * Release number
     */
    const UNTDID_7143_RN = 'RN';

    /**
     * Run number
     */
    const UNTDID_7143_RU = 'RU';

    /**
     * Record keeping of model year
     */
    const UNTDID_7143_RY = 'RY';

    /**
     * Supplier's article number
     */
    const UNTDID_7143_SA = 'SA';

    /**
     * Standard group of products (mixed assortment)
     */
    const UNTDID_7143_SG = 'SG';

    /**
     * SKU (Stock keeping unit)
     */
    const UNTDID_7143_SK = 'SK';

    /**
     * Serial number
     */
    const UNTDID_7143_SN = 'SN';

    /**
     * RSK number
     */
    const UNTDID_7143_SRS = 'SRS';

    /**
     * IFLS (Institut Francais du Libre Service) 5 digit product
     */
    const UNTDID_7143_SRT = 'SRT';

    /**
     * IFLS (Institut Francais du Libre Service) 9 digit product
     */
    const UNTDID_7143_SRU = 'SRU';

    /**
     * GS1 Global Trade Item Number
     */
    const UNTDID_7143_SRV = 'SRV';

    /**
     * EDIS (Energy Data Identification System)
     */
    const UNTDID_7143_SRW = 'SRW';

    /**
     * Slaughter number
     */
    const UNTDID_7143_SRX = 'SRX';

    /**
     * Official animal number
     */
    const UNTDID_7143_SRY = 'SRY';

    /**
     * Harmonized tariff schedule
     */
    const UNTDID_7143_SRZ = 'SRZ';

    /**
     * Supplier's supplier article number
     */
    const UNTDID_7143_SS = 'SS';

    /**
     * 46 Level DOT Code
     */
    const UNTDID_7143_SSA = 'SSA';

    /**
     * Airline Tariff 6D
     */
    const UNTDID_7143_SSB = 'SSB';

    /**
     * Title 49 Code of Federal Regulations
     */
    const UNTDID_7143_SSC = 'SSC';

    /**
     * International Civil Aviation Administration code
     */
    const UNTDID_7143_SSD = 'SSD';

    /**
     * Hazardous Materials ID DOT
     */
    const UNTDID_7143_SSE = 'SSE';

    /**
     * Endorsement
     */
    const UNTDID_7143_SSF = 'SSF';

    /**
     * Air Force Regulation 71-4
     */
    const UNTDID_7143_SSG = 'SSG';

    /**
     * Breed
     */
    const UNTDID_7143_SSH = 'SSH';

    /**
     * Chemical Abstract Service (CAS) registry number
     */
    const UNTDID_7143_SSI = 'SSI';

    /**
     * Engine model designation
     */
    const UNTDID_7143_SSJ = 'SSJ';

    /**
     * Institutional Meat Purchase Specifications (IMPS) Number
     */
    const UNTDID_7143_SSK = 'SSK';

    /**
     * Price Look-Up code (PLU)
     */
    const UNTDID_7143_SSL = 'SSL';

    /**
     * International Maritime Organization (IMO) Code
     */
    const UNTDID_7143_SSM = 'SSM';

    /**
     * Bureau of Explosives 600-A (rail)
     */
    const UNTDID_7143_SSN = 'SSN';

    /**
     * United Nations Dangerous Goods List
     */
    const UNTDID_7143_SSO = 'SSO';

    /**
     * International Code of Botanical Nomenclature (ICBN)
     */
    const UNTDID_7143_SSP = 'SSP';

    /**
     * International Code of Zoological Nomenclature (ICZN)
     */
    const UNTDID_7143_SSQ = 'SSQ';

    /**
     * International Code of Nomenclature for Cultivated Plants
     */
    const UNTDID_7143_SSR = 'SSR';

    /**
     * Distributor’s article identifier
     */
    const UNTDID_7143_SSS = 'SSS';

    /**
     * Norwegian Classification system ENVA
     */
    const UNTDID_7143_SST = 'SST';

    /**
     * Supplier assigned classification
     */
    const UNTDID_7143_SSU = 'SSU';

    /**
     * Mexican classification system AMECE
     */
    const UNTDID_7143_SSV = 'SSV';

    /**
     * German classification system CCG
     */
    const UNTDID_7143_SSW = 'SSW';

    /**
     * Finnish classification system EANFIN
     */
    const UNTDID_7143_SSX = 'SSX';

    /**
     * Canadian classification system ICC
     */
    const UNTDID_7143_SSY = 'SSY';

    /**
     * French classification system IFLS5
     */
    const UNTDID_7143_SSZ = 'SSZ';

    /**
     * Style number
     */
    const UNTDID_7143_ST = 'ST';

    /**
     * Dutch classification system CBL
     */
    const UNTDID_7143_STA = 'STA';

    /**
     * Japanese classification system JICFS
     */
    const UNTDID_7143_STB = 'STB';

    /**
     * European Union dairy subsidy eligibility classification
     */
    const UNTDID_7143_STC = 'STC';

    /**
     * GS1 Spain classification system
     */
    const UNTDID_7143_STD = 'STD';

    /**
     * GS1 Poland classification system
     */
    const UNTDID_7143_STE = 'STE';

    /**
     * Federal Agency on Technical Regulating and Metrology of the
     */
    const UNTDID_7143_STF = 'STF';

    /**
     * Efficient Consumer Response (ECR) Austria classification
     */
    const UNTDID_7143_STG = 'STG';

    /**
     * GS1 Italy classification system
     */
    const UNTDID_7143_STH = 'STH';

    /**
     * CPV (Common Procurement Vocabulary)
     */
    const UNTDID_7143_STI = 'STI';

    /**
     * IFDA (International Foodservice Distributors Association)
     */
    const UNTDID_7143_STJ = 'STJ';

    /**
     * AHFS (American Hospital Formulary Service) pharmacologic -
     */
    const UNTDID_7143_STK = 'STK';

    /**
     * ATC (Anatomical Therapeutic Chemical) classification system
     */
    const UNTDID_7143_STL = 'STL';

    /**
     * CLADIMED (Classification des Dispositifs Médicaux)
     */
    const UNTDID_7143_STM = 'STM';

    /**
     * CMDR (Canadian Medical Device Regulations) classification
     */
    const UNTDID_7143_STN = 'STN';

    /**
     * CNDM (Classificazione Nazionale dei Dispositivi Medici)
     */
    const UNTDID_7143_STO = 'STO';

    /**
     * UK DM&D (Dictionary of Medicines & Devices) standard coding
     */
    const UNTDID_7143_STP = 'STP';

    /**
     * eCl@ss
     */
    const UNTDID_7143_STQ = 'STQ';

    /**
     * EDMA (European Diagnostic Manufacturers Association)
     */
    const UNTDID_7143_STR = 'STR';

    /**
     * EGAR (European Generic Article Register)
     */
    const UNTDID_7143_STS = 'STS';

    /**
     * GMDN (Global Medical Devices Nomenclature)
     */
    const UNTDID_7143_STT = 'STT';

    /**
     * GPI (Generic Product Identifier)
     */
    const UNTDID_7143_STU = 'STU';

    /**
     * HCPCS (Healthcare Common Procedure Coding System)
     */
    const UNTDID_7143_STV = 'STV';

    /**
     * ICPS (International Classification for Patient Safety)
     */
    const UNTDID_7143_STW = 'STW';

    /**
     * MedDRA (Medical Dictionary for Regulatory Activities)
     */
    const UNTDID_7143_STX = 'STX';

    /**
     * Medical Columbus
     */
    const UNTDID_7143_STY = 'STY';

    /**
     * NAPCS (North American Product Classification System)
     */
    const UNTDID_7143_STZ = 'STZ';

    /**
     * NHS (National Health Services) eClass
     */
    const UNTDID_7143_SUA = 'SUA';

    /**
     * US FDA (Food and Drug Administration) Product Code
     */
    const UNTDID_7143_SUB = 'SUB';

    /**
     * SNOMED CT (Systematized Nomenclature of Medicine-Clinical
     */
    const UNTDID_7143_SUC = 'SUC';

    /**
     * UMDNS (Universal Medical Device Nomenclature System)
     */
    const UNTDID_7143_SUD = 'SUD';

    /**
     * GS1 Global Returnable Asset Identifier, non-serialised
     */
    const UNTDID_7143_SUE = 'SUE';

    /**
     * IMEI
     */
    const UNTDID_7143_SUF = 'SUF';

    /**
     * Waste Type (EMSA)
     */
    const UNTDID_7143_SUG = 'SUG';

    /**
     * Ship's store classification type
     */
    const UNTDID_7143_SUH = 'SUH';

    /**
     * Emergency fire code
     */
    const UNTDID_7143_SUI = 'SUI';

    /**
     * Emergency spillage code
     */
    const UNTDID_7143_SUJ = 'SUJ';

    /**
     * IMDG packing group
     */
    const UNTDID_7143_SUK = 'SUK';

    /**
     * MARPOL Code IBC
     */
    const UNTDID_7143_SUL = 'SUL';

    /**
     * IMDG subsidiary risk class
     */
    const UNTDID_7143_SUM = 'SUM';

    /**
     * Transport group number
     */
    const UNTDID_7143_TG = 'TG';

    /**
     * Taxonomic Serial Number
     */
    const UNTDID_7143_TSN = 'TSN';

    /**
     * IMDG main hazard class
     */
    const UNTDID_7143_TSO = 'TSO';

    /**
     * EU Combined Nomenclature
     */
    const UNTDID_7143_TSP = 'TSP';

    /**
     * Therapeutic classification number
     */
    const UNTDID_7143_TSQ = 'TSQ';

    /**
     * European Waste Catalogue
     */
    const UNTDID_7143_TSR = 'TSR';

    /**
     * Price grouping code
     */
    const UNTDID_7143_TSS = 'TSS';

    /**
     * UNSPSC
     */
    const UNTDID_7143_TST = 'TST';

    /**
     * Ultimate customer's article number
     */
    const UNTDID_7143_UA = 'UA';

    /**
     * UPC (Universal product code)
     */
    const UNTDID_7143_UP = 'UP';

    /**
     * Vendor item number
     */
    const UNTDID_7143_VN = 'VN';

    /**
     * Vendor's (seller's) part number
     */
    const UNTDID_7143_VP = 'VP';

    /**
     * Vendor's supplemental item number
     */
    const UNTDID_7143_VS = 'VS';

    /**
     * Vendor specification number
     */
    const UNTDID_7143_VX = 'VX';

    /**
     * Mutually defined
     */
    const UNTDID_7143_ZZZ = 'ZZZ';
}
